/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChunkData
implements IMessage {
    private NBTTagCompound nbt;
    private int x;
    private int z;
    private float regionalTemp;
    private float rainfall;

    @Deprecated
    public PacketChunkData() {
    }

    public PacketChunkData(ChunkPos chunkPos, NBTTagCompound nbt, float regionalTemp, float rainfall) {
        this.x = chunkPos.field_77276_a;
        this.z = chunkPos.field_77275_b;
        this.nbt = nbt;
        this.regionalTemp = regionalTemp;
        this.rainfall = rainfall;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.regionalTemp = buf.readFloat();
        this.rainfall = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeFloat(this.regionalTemp);
        buf.writeFloat(this.rainfall);
    }

    public static class Handler
    implements IMessageHandler<PacketChunkData, IMessage> {
        public IMessage onMessage(PacketChunkData message, MessageContext ctx) {
            World world = TerraFirmaCraft.getProxy().getWorld(ctx);
            if (world != null) {
                TerraFirmaCraft.getProxy().getThreadListener(ctx).func_152344_a(() -> {
                    Chunk chunk = world.func_72964_e(message.x, message.z);
                    ChunkDataTFC data = (ChunkDataTFC)chunk.getCapability(ChunkDataProvider.CHUNK_DATA_CAPABILITY, null);
                    if (data != null) {
                        ChunkDataProvider.CHUNK_DATA_CAPABILITY.readNBT((Object)data, null, (NBTBase)message.nbt);
                    }
                    ClimateTFC.update(chunk.func_76632_l(), message.regionalTemp, message.rainfall);
                });
            }
            return null;
        }
    }
}

